<x-user.content>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:head>
        <style>
            a.link_data {
                position: absolute;
                z-index: 1;
                right: 60px;
            }

            div.pointukar {
                background-color: red;
                z-index: 1;
                padding: 3px;
                text-align: center;
                color: white;
            }

            @media only screen and (max-width: 600px) {
                a.link_data {
                    position: absolute;
                    z-index: 1;
                    right: 15px;
                }

                div.pointukar {
                    background-color: red;
                    z-index: 1;
                    padding: 3px;
                    text-align: center;
                    color: white;
                    font-size: 10px;
                }
            }
        </style>
    </x-slot:head>
    <!-- Carousel Start -->
    <div class="container-fluid mb-3">
        <div class="row px-xl-5">
            <div class="col-lg-8 ">
                <div id="header-carousel" class="carousel slide carousel-fade mb-30 mb-lg-0" data-ride="carousel">
                    <ol class="carousel-indicators">
                        @php
                            $i = 0;
                        @endphp
                        @foreach ($slid as $s)
                            <li data-target="#header-carousel" data-slide-to="{{ $i }}"
                                class="{{ $i == 0 ? 'active' : '' }}"></li>
                            @php
                                $i++;
                            @endphp
                        @endforeach
                    </ol>
                    <div class="carousel-inner">
                        @foreach ($slid as $s)
                            <div class="carousel-item position-relative {{ $no == 1 ? 'active' : '' }}"
                                style="height: 430px; background-color: black">
                                <a href="{{ $s->link }}">
                                    <img class="position-absolute w-100 h-100"
                                        src="{{ asset('/storage/banner/' . $s->gambar) }}" style="object-fit: cover; ">
                                    <div
                                        class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                                        @if ($s->link != '#')
                                            <div class="p-3" style="max-width: 700px;">
                                                <h1
                                                    class="display-4 text-white mb-3 animate__animated animate__fadeInDown text-dark">
                                                    {{ $s->judul }}</h1>
                                                <p class="mx-md-5 px-5 animate__animated animate__bounceIn text-dark">
                                                    Lorem
                                                    {{ $s->isi }}
                                                </p>
                                                <a class="btn btn-outline-danger py-2 px-4 mt-3 animate__animated animate__fadeInUp"
                                                    href="#">Cek Sekarang</a>
                                            </div>
                                        @endif
                                    </div>
                                </a>
                            </div>
                            @php
                                $no++;
                            @endphp
                        @endforeach


                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                @foreach ($ban_atas as $b)
                    <div class="product-offer mb-30" style="height: 200px;">
                        <img class="img-fluid" src="{{ asset('/storage/banner/' . $b->gambar) }}" alt="">
                        @if ($b->link != '#')
                            <div class="offer-text">
                                <h6 class="text-white text-uppercase">{{ $b->isi }}</h6>
                                <h3 class="text-white mb-3">{{ $b->judul }}</h3>
                                <a href="{{ $b->link }}" class="btn btn-danger">Cek Sekarang</a>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- Carousel End -->





    <!-- Products Start -->
    <div class="container-fluid pt-5 pb-3" id="prod">
        <a href="/list-produk" class="btn btn-danger link_data">Cek Produk <i
                class="fa fa-angle-double-right ml-3"></i></a>
        <h2 class="section-title position-relative text-uppercase mx-xl-5 mb-4"><span
                class="bg-secondary pr-3">Produk</span></h2>
        <div class="row px-xl-5">

            @forelse ($produk as $p)
                <div class="col-lg-2 col-md-4 col-sm-6 pb-1">
                    <div class="product-item bg-light mb-4">
                        <div class="product-img position-relative overflow-hidden">
                            @if ($p->gambar != null)
                                <img class="img-fluid w-100" src="{{ asset('/storage/produk/' . $p->gambar) }}"
                                    alt="produk">
                            @else
                                <img alt="produk" class="img-fluid w-100"
                                    src="{{ asset('storage/produk/produk.jpg') }}">
                            @endif
                            <div class="product-action">

                                <a class="btn btn-outline-dark btn-square" href="detail/{{ $p->link_produk }}"><i
                                        class="fa fa-search"></i></a>
                            </div>
                        </div>
                        <div class="text-center py-4">
                            <a class="h6 text-decoration-none text-truncate" href="detail/{{ $p->link_produk }}">
                                @if (strlen($p->nm_produk) > 17)
                                    {{ substr($p->nm_produk, 0, 25) }}...
                                @else
                                    {{ $p->nm_produk }}
                                @endif
                            </a>
                            <div class="d-flex align-items-center justify-content-center mt-2">
                                @if ($p->diskon == 0)
                                    <h5>Rp. {{ number_format($p->harga_jual, 0, ',', '.') }}</h5>
                                @else
                                    <h5>Rp.
                                        {{ number_format($p->harga_jual - ($p->harga_jual * $p->diskon) / 100, 0, ',', '.') }}
                                    </h5>
                                    <h6 class="text-muted ml-2"><del>Rp.
                                            {{ number_format($p->harga_jual, 0, ',', '.') }}</del></h6>
                                @endif


                            </div>
                            @php
                                $cek = stok($p->id) - terjual($p->id);
                            @endphp
                            <button class="btn  btn-block {{ $cek == 0 ? 'btn-default disabled' : 'btn-info beli' }}"
                                data-kd="{{ $p->kd_produk }}">
                                {!! $cek == 0 ? 'Stok Habis' : '<i class="fa fa-cart-plus"></i> Masukan keranjang' !!}
                            </button>
                        </div>
                    </div>
                </div>
            @empty
            @endforelse

        </div>
    </div>
    <!-- Products End -->


    <!-- Offer Start -->
    <div class="container-fluid pt-5 pb-3">
        <div class="row px-xl-5">
            @foreach ($ban_bawah as $b)
                <div class="col-md-6">
                    <div class="product-offer mb-30" style="height: 300px;">
                        <img class="img-fluid" src="{{ asset('/storage/banner/' . $b->gambar) }}" alt="">
                        @if ($b->link != '#')
                            <div class="offer-text">
                                <h6 class="text-white text-uppercase">{{ $b->isi }}</h6>
                                <h3 class="text-white mb-3">{{ $b->judul }}</h3>
                                <a href="{{ $b->link }}" class="btn btn-danger">
                                    Cek Sekarang</a>
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach



        </div>
    </div>
    <!-- Offer End -->





    <!-- Vendor Start -->
    <div class="container-fluid py-5">
        <a href="/list-item" class="btn btn-warning link_data">Cek Hadiah <i
                class="fa fa-angle-double-right ml-3"></i></a>
        <h2 class="section-title position-relative text-uppercase mx-xl-5 mb-4"><span class="bg-secondary pr-3">Tukar
                Poin
            </span></h2>

        <div class="row px-xl-5">
            <div class="col">
                <div class="owl-carousel vendor-carousel">
                    @forelse ($item as $i)
                        <div class="bg-light p-4 ">
                            <img src="{{ asset('/storage/produk/' . $i->gambar) }}" alt="">
                            <div class="pointukar">
                                {{ $i->poin }} Poin
                            </div>
                        </div>
                    @empty
                    @endforelse


                </div>
            </div>
        </div>
    </div>
    <!-- Vendor End -->

    <x-slot:foot>

    </x-slot:foot>
</x-user.content>
